/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.screenshot.viewer;

import club.sk1er.elementa.UIComponent;
import club.sk1er.elementa.components.UIImage;
import club.sk1er.elementa.components.Window;
import club.sk1er.elementa.components.image.DefaultLoadingImage;
import club.sk1er.elementa.components.image.ImageProvider;
import club.sk1er.elementa.constraints.ColorConstraint;
import club.sk1er.elementa.constraints.ConstantColorConstraint;
import club.sk1er.elementa.constraints.HeightConstraint;
import club.sk1er.elementa.constraints.PixelConstraint;
import club.sk1er.elementa.constraints.RelativeConstraint;
import club.sk1er.elementa.constraints.WidthConstraint;
import club.sk1er.elementa.constraints.XConstraint;
import club.sk1er.elementa.constraints.YConstraint;
import club.sk1er.elementa.constraints.animation.AnimatingConstraints;
import club.sk1er.elementa.constraints.animation.AnimationStrategy;
import club.sk1er.elementa.constraints.animation.Animations;
import club.sk1er.patcher.config.PatcherConfig;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Viewer {
    private Window currentWindow;

    @SubscribeEvent
    public void renderScreenshot(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (this.currentWindow == null) {
            return;
        }
        this.currentWindow.draw();
    }

    public void newCapture(BufferedImage image) {
        this.currentWindow = new Window();
        this.instantiateComponents(image);
    }

    private void instantiateComponents(BufferedImage image) {
        UIComponent imageComponent = new UIImage(CompletableFuture.completedFuture(image), (ImageProvider)DefaultLoadingImage.INSTANCE).setX((XConstraint)new PixelConstraint(0.0f)).setY((YConstraint)new PixelConstraint(0.0f)).setWidth((WidthConstraint)new RelativeConstraint(1.0f)).setHeight((HeightConstraint)new RelativeConstraint(1.0f));
        this.currentWindow.addChild(imageComponent);
        int style = PatcherConfig.previewAnimationStyle;
        float previewScale = 1.0f / (float)PatcherConfig.previewScale;
        AnimatingConstraints animation = null;
        if (style == 0) {
            animation = imageComponent.makeAnimation().setWidthAnimation((AnimationStrategy)Animations.OUT_QUINT, 1.5f, (WidthConstraint)new RelativeConstraint(previewScale)).setHeightAnimation((AnimationStrategy)Animations.OUT_QUINT, 1.5f, (HeightConstraint)new RelativeConstraint(previewScale)).setXAnimation((AnimationStrategy)Animations.OUT_QUINT, 1.5f, (XConstraint)new PixelConstraint(10.0f, true)).setYAnimation((AnimationStrategy)Animations.OUT_QUINT, 1.5f, (YConstraint)new PixelConstraint(10.0f, true)).onCompleteRunnable(() -> this.slideOutAnimation(imageComponent));
        } else if (style == 1) {
            imageComponent.setWidth((WidthConstraint)new RelativeConstraint(previewScale)).setHeight((HeightConstraint)new RelativeConstraint(previewScale)).setX((XConstraint)new RelativeConstraint(1.0f)).setY((YConstraint)new PixelConstraint(10.0f, true));
            animation = imageComponent.makeAnimation().setXAnimation((AnimationStrategy)Animations.OUT_QUINT, 1.5f, (XConstraint)new PixelConstraint(10.0f, true)).onCompleteRunnable(() -> this.slideOutAnimation(imageComponent));
        } else if (style == 2) {
            imageComponent.setWidth((WidthConstraint)new RelativeConstraint(previewScale)).setHeight((HeightConstraint)new RelativeConstraint(previewScale)).setX((XConstraint)new PixelConstraint(10.0f, true)).setY((YConstraint)new PixelConstraint(10.0f, true));
            animation = imageComponent.makeAnimation().onCompleteRunnable(() -> this.fakeAnimation(imageComponent));
        }
        if (animation != null) {
            imageComponent.animateTo(animation);
        }
    }

    private void slideOutAnimation(UIComponent container) {
        AnimatingConstraints slideAnimation = container.makeAnimation().setXAnimation((AnimationStrategy)Animations.IN_OUT_CIRCULAR, 1.0f, (XConstraint)new RelativeConstraint(2.0f), (float)PatcherConfig.previewTime).onCompleteRunnable(() -> {
            this.currentWindow = null;
        });
        container.animateTo(slideAnimation);
    }

    private void fakeAnimation(UIComponent container) {
        AnimatingConstraints slideAnimation = container.makeAnimation().setColorAnimation((AnimationStrategy)Animations.IN_OUT_CIRCULAR, 1.0f, (ColorConstraint)new ConstantColorConstraint(new Color(255, 255, 255, 255)), (float)PatcherConfig.previewTime).onCompleteRunnable(() -> {
            this.currentWindow = null;
        });
        container.animateTo(slideAnimation);
    }
}

